<?php
// no direct access
defined( '_JCE_EXT' ) or die( 'Restricted access' );
class AdvlinkRokdownloads {	
	function getOptions(){
		$advlink =& AdvLink::getInstance();
		$list = '';
		if( $advlink->checkAccess( 'advlink_rokdownloads', '1' ) ){
			$list = '<li id="index.php?option=com_rokdownloads"><div class="tree-row"><div class="tree-image"></div><span class="folder rokdownloads nolink"><a href="javascript:;">' . JText::_('ROKDOWNLOADS') . '</a></span></div></li>';
		}
		return $list;	
	}
	function getItems( $args ){		
		global $mainframe;
		
		jimport('joomla.filesystem.file');
		
		$id = isset( $args->id ) ? $args->id : 1;
		
		//get folders
        $nodes = AdvlinkRokdownloads::getFolders( $id );

		$items 	= array();
		$view	= isset( $args->view ) ? $args->view : '';
		
		foreach( $nodes as $node ){
			$view	= $node->folder ? 'folder' : 'file';
			$class 	= $view == 'file' ? $view . ' ' . JFile::getExt( $node->name ) : $view;
			 			
			$items[] = array(
				'id'		=>	'index.php?option=com_rokdownloads&view=' . $view . '&id=' . AdvlinkRokdownloads::getSlug( $node ) . AdvlinkRokdownloads::getItemId( $node ),
				'name'		=>	$node->displayname,
				'class'		=>	$class . ' rokdownloads'
			);
		}			
		return $items;
	}
	function getMenus(){
		$db =& JFactory::getDBO();
		
		$query = 'SELECT id, params'
		. ' FROM #__menu'
		. ' WHERE link LIKE '. $db->Quote( 'index.php?option=com_rokdownloads&view=%' )
		. ' AND published = 1'
		;
		
		$db->setQuery( $query );
		return $db->loadObjectList();
	}	
	function getRoot(){
		$db =& JFactory::getDBO();
		
		$query = 'SELECT *'
		. ' FROM #__rokdownloads'
		. ' WHERE lft = 1'
		;	    	
		
		$db->setQuery( $query );
		return $db->loadObject();
	}
	/**
	 * Gets the hierarchy of ordered folders from the database.  It does return the parent folder.
	 *
	 * @access public
	 * @return Array An ordered array of folders if successfull and false if not
	 */
	function getFolders( $id ) {
		$db =& JFactory::getDBO();
		//ajout gmaccess
		$user		=& JFactory::getUser();
		$aid		= (int) $user->get('aid', 0);
		//fin gmaccess
    	$query = "select DISTINCTROW a.*, g.name AS groups FROM "
		." (SELECT node.*, (COUNT(parent.name) - (sub_tree.depth + 1)) AS depth "
		." FROM #__rokdownloads AS node, #__rokdownloads AS parent, #__rokdownloads AS sub_parent,"
		." (SELECT node.id, (COUNT(parent.name) - 1) AS depth FROM #__rokdownloads AS node, #__rokdownloads AS parent"
		." WHERE node.lft BETWEEN parent.lft AND parent.rgt"
		." AND node.id = ".(int) $id 
		." GROUP BY node.id ORDER BY node.lft ) AS sub_tree"
		." WHERE node.lft BETWEEN parent.lft AND parent.rgt AND node.lft BETWEEN sub_parent.lft"
		." AND sub_parent.rgt AND sub_parent.id = sub_tree.id and node.published = 1"
		." GROUP BY node.id HAVING depth = 1 ORDER BY node.lft) as a"
		//ajout gmaccess
		. " LEFT JOIN #__gmacl AS gi ON a.id = gi.axo AND gi.aco = 'read' AND gi.axosection = 'rokdownload'"
		//fin gmaccess
		." LEFT JOIN #__groups AS g ON a.access = g.id"
		//ajout gmaccess
		." WHERE (gi.aro IN ( ".$user->gmid." ) OR a.access <= ". (int) $aid . ")"
		. "order by a.folder DESC"
		//fin gmaccess
		;	    	
		
		$db->setQuery( $query );
		return $db->loadObjectList();
    }
	function getSlug($node) {
    	// Add id
    	$slug = $node->id;
		$slug .= ":";
		
		// Strip extension is there is one
		$name = $node->name;
		$ext = strrchr($name, '.');
		if($ext !== false)
		{
			$name = substr($name, 0, -strlen($ext));
		} 
		
		// lower case the name
		$name = JString::strtolower($name);
		
		// Change spaces and periods to  dashes
		$name = JString::str_ireplace(" ", "-", $name);
		$name = JString::str_ireplace(".", "-", $name);
		
		$slug .= $name;
		return $slug;
    }
	function getItemId( $node ){
		$db =& JFactory::getDBO();
		
		$view = $node->folder ? 'folder' : 'file';
		
		$query = 'SELECT id'
		. ' FROM #__rokdownloads'
		. ' WHERE path = '. $db->Quote( dirname( $node->path ) )
		;	    	
		
		$db->setQuery( $query );
		$parent = $db->loadResult();
		
		$menus = AdvlinkRokdownloads::getMenus();
		//ajout gmaccess
		$id=0;
		//fin gmaccess
		foreach( $menus as $menu ){					
			$params = new JParameter( $menu->params );
			if( $params->get('top_level_folder') == $parent ){
				$id = $menu->id;
			}
			if( $params->get('top_level_folder') == $node->id ){
				$id = $menu->id;
			}
			if( $params->get('filetodisplay') == $node->id ){
				$id = $menu->id;
			}
		}
		return $id ? '&ItemId=' . $id : '';
	}
}
?>